<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Services\FormService;

class FormController extends Controller
{
    public function show(string $formId, FormService $formService)
    {
        try {
            $formSchema = $formService->getFormSchema($formId);
            
            return response()->json([
                'success' => true,
                'data' => $formSchema,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'errors' => $e->getMessage(),
            ], 404);
        }
    }
}
