<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Setting;

class CheckRegistrationOpen
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $registrationOpen = Setting::get('registration_open', true);

        if (!$registrationOpen) {
            return response()->json([
                'status' => false,
                'message' => 'لقد تم انتهاء مدة التسجيل',
                'registration_closed' => true,
            ], 403);
        }

        return $next($request);
    }
}
