<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RoleMiddleware
{
  /**
   * Handle an incoming request.
   *
   * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
   */
  public function handle(Request $request, Closure $next, string $role): Response
  {
    $user = $request->user();

    if (!$user) {
      return response()->json([
        'success' => false,
        'message' => 'Unauthenticated',
      ], 401);
    }

    if ($user->role !== $role && $user->role !== 'admin') {
      return response()->json([
        'success' => false,
        'message' => 'Unauthorized. Required role: ' . $role,
      ], 403);
    }

    return $next($request);
  }
}
