<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreApplicantRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [

            // Basic info
            'full_name_ar' => ['required', 'string'],
            'full_name_en' => ['required', 'string'],

            'national_id' => ['required', 'digits:14', 'unique:applicants,national_id'],
            'passport_number' => ['nullable', 'string'],

            'dob' => ['required', 'date'],
            'gender' => ['required', 'in:male,female'],
            'military_status' => ['required_if:gender,male', 'nullable', 'string'],

            'mobile' => ['required', 'string'],
            'whatsapp' => ['nullable', 'string'],
            'email' => ['required', 'email', 'unique:applicants,email'],
            // 'password' => ['required', 'string', 'min:8'],

            'address' => ['required', 'string'],
            'district' => ['required', 'string'],
            'governorate_id' => ['required', 'exists:governorates,id'],
            'birth_place' => ['required', 'string'],

            // Nationalities
            'nationalities' => ['nullable', 'array'],
            'nationalities.*.country_id' => ['required_if:nationalities,!=,null', 'exists:countries,id'],

            // Education
            'degree' => ['required', 'string'],
            'major' => ['required', 'string'],
            'college' => ['required', 'string'],
            'university' => ['required', 'string'],

            'is_studying' => ['required', 'boolean'],
            'study_year' => ['required_if:is_studying,true', 'nullable', 'string'],
            'grad_year' => ['required_if:is_studying,false', 'nullable', 'string'],

            // Extra degrees
            'degrees' => ['nullable', 'array'],
            'degrees.*.degree_title' => ['required_if:degrees,!=,null', 'string'],
            'degrees.*.institution' => ['required_if:degrees,!=,null', 'string'],
            'degrees.*.year' => ['required_if:degrees,!=,null', 'string'],

            // Languages
            'languages' => ['nullable', 'array'],
            'languages.*.language_id' => ['required_if:languages,!=,null', 'exists:languages,id'],
            'languages.*.proficiency' => ['required_if:languages,!=,null', 'in:excellent,very_good,good,fair'],

            // Experience
            'current_job' => ['nullable', 'string'],
            'employer' => ['nullable', 'string'],

            'experience_public' => ['required', 'string'],
            'experience_ministry' => ['nullable', 'string'],
            'experience_other_orgs' => ['nullable', 'string'],
            'visited_countries' => ['nullable', 'string'],
            'center_memberships' => ['nullable', 'string'],
            'club_memberships' => ['nullable', 'string'],
            'sports' => ['nullable', 'string'],
            'skills_hobbies' => ['required', 'string'],

            // Motivation
            'motivation' => ['required', 'string'],
            'strengths' => ['required', 'string'],
            'weaknesses' => ['required', 'string'],

            // Documents
            'documents' => ['required', 'array'],

            'documents.national_id' => ['required', 'image'],
            'documents.cv' => ['required', 'file', 'mimes:pdf'],

            'documents.photo_casual' => ['required', 'array'],
            'documents.photo_casual.*' => ['required', 'image'],

            'documents.photo_official' => ['required', 'image'],

            // Social media
            'facebook' => ['nullable', 'url'],
            'instagram' => ['nullable', 'url'],
            'linkedin' => ['nullable', 'url'],

            // Physical
            'height' => ['required', 'numeric'],
            'weight' => ['required', 'numeric'],
        ];
    }

    public function messages(): array
    {
        return [

            // Basic info
            'full_name_ar.required' => 'الاسم العربي مطلوب.',
            'full_name_en.required' => 'الاسم الإنجليزي مطلوب.',

            'national_id.required' => 'الرقم القومي مطلوب.',
            'national_id.digits' => 'الرقم القومي يجب أن يتكون من 14 رقمًا.',
            'national_id.unique' => 'الرقم القومي مستخدم من قبل.',

            'passport_number.string' => 'رقم جواز السفر يجب أن يكون نصًا.',

            'dob.required' => 'تاريخ الميلاد مطلوب.',
            'dob.date' => 'يجب إدخال تاريخ ميلاد صالح.',

            'gender.required' => 'النوع مطلوب.',
            'gender.in' => 'قيمة النوع غير صحيحة.',

            'military_status.required_if' => 'حالة التجنيد مطلوبة للذكور.',

            'mobile.required' => 'رقم الهاتف مطلوب.',
            'email.required' => 'البريد الإلكتروني مطلوب.',
            'email.email' => 'يجب إدخال بريد إلكتروني صالح.',
            'email.unique' => 'هذا البريد الإلكتروني مسجل بالفعل.',
            // 'password.required' => 'كلمة المرور مطلوبة.',
            // 'password.min' => 'كلمة المرور يجب أن تكون 8 أحرف على الأقل.',

            'address.required' => 'العنوان مطلوب.',
            'district.required' => 'المنطقة مطلوبة.',

            'governorate_id.required' => 'المحافظة مطلوبة.',
            'governorate_id.exists' => 'المحافظة المختارة غير موجودة.',

            'birth_place.required' => 'مكان الميلاد مطلوب.',

            // Nationalities
            'nationalities.required' => 'الجنسيات مطلوبة.',
            'nationalities.array' => 'الجنسيات يجب أن تكون في شكل مصفوفة.',
            'nationalities.*.country_id.required' => 'الدولة مطلوبة.',
            'nationalities.*.country_id.exists' => 'الدولة غير موجودة.',

            // Education
            'degree.required' => 'الدرجة العلمية مطلوبة.',
            'major.required' => 'التخصص مطلوب.',
            'college.required' => 'الكلية مطلوبة.',
            'university.required' => 'الجامعة مطلوبة.',

            'is_studying.required' => 'حالة الدراسة مطلوبة.',
            'study_year.required_if' => 'سنة الدراسة مطلوبة.',
            'grad_year.required_if' => 'سنة التخرج مطلوبة.',

            // Extra degrees
            'degrees.required' => 'الشهادات الإضافية مطلوبة.',
            'degrees.array' => 'الشهادات يجب أن تكون مصفوفة.',
            'degrees.*.degree_title.required' => 'عنوان الشهادة مطلوب.',
            'degrees.*.institution.required' => 'اسم المؤسسة التعليمية مطلوب.',
            'degrees.*.year.required' => 'سنة الحصول على الشهادة مطلوبة.',

            // Languages
            'languages.array' => 'اللغات يجب أن تكون في شكل مصفوفة.',
            'languages.*.language_id.required' => 'اللغة مطلوبة.',
            'languages.*.language_id.exists' => 'اللغة غير موجودة.',
            'languages.*.proficiency.required' => 'مستوى الإجادة مطلوب.',

            // Experience
            'experience_public.required' => 'الخبرة في القطاع العام مطلوبة.',
            'experience_ministry.required' => 'الخبرة في الوزارة مطلوبة.',
            'experience_other_orgs.required' => 'الخبرة في المنظمات الأخرى مطلوبة.',
            'visited_countries.required' => 'الدول التي قمت بزيارتها مطلوبة.',
            'center_memberships.required' => 'العضويات في المراكز مطلوبة.',
            'club_memberships.required' => 'عضويات الأندية مطلوبة.',
            'sports.required' => 'الرياضات مطلوبة.',
            'skills_hobbies.required' => 'المهارات والهوايات مطلوبة.',

            // Motivation
            'motivation.required' => 'الدافع مطلوب.',
            'strengths.required' => 'نقاط القوة مطلوبة.',
            'weaknesses.required' => 'نقاط الضعف مطلوبة.',

            // Documents
            'documents.required' => 'الوثائق مطلوبة.',
            'documents.array' => 'الوثائق يجب أن تكون مصفوفة.',

            'documents.national_id.required' => 'صورة بطاقة الرقم القومي مطلوبة.',
            'documents.national_id.image' => 'يجب رفع صورة صالحة للرقم القومي.',

            'documents.cv.required' => 'السيرة الذاتية مطلوبة.',
            'documents.cv.mimes' => 'السيرة الذاتية يجب أن تكون ملف PDF.',

            'documents.photo_casual.required' => 'صور الكاجوال مطلوبة.',
            'documents.photo_casual.array' => 'صور الكاجوال يجب أن تكون مصفوفة.',
            'documents.photo_casual.*.image' => 'كل صورة كاجوال يجب أن تكون صورة صالحة.',

            'documents.photo_official.required' => 'الصورة الرسمية مطلوبة.',
            'documents.photo_official.image' => 'الصورة الرسمية يجب أن تكون صورة.',

            // Social media
            'facebook.required' => 'رابط فيسبوك مطلوب.',
            'facebook.url' => 'يجب إدخال رابط فيسبوك صحيح.',

            'instagram.required' => 'رابط إنستجرام مطلوب.',
            'instagram.url' => 'يجب إدخال رابط إنستجرام صحيح.',

            'linkedin.required' => 'رابط لينكدإن مطلوب.',
            'linkedin.url' => 'يجب إدخال رابط لينكدإن صحيح.',

            // Physical
            'height.required' => 'الطول مطلوب.',
            'height.numeric' => 'الطول يجب أن يكون رقمًا.',

            'weight.required' => 'الوزن مطلوب.',
            'weight.numeric' => 'الوزن يجب أن يكون رقمًا.',
        ];
    }
}
