<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantDocument extends Model
{
    use SoftDeletes;
    protected $fillable = ['applicant_id', 'type', 'file_path'];

    public const TYPE_NATIONAL_ID = 'national_id';
    public const TYPE_CV = 'cv';
    public const TYPE_PHOTO_CASUAL = 'photo_casual';
    public const TYPE_PHOTO_OFFICIAL = 'photo_official';

    public function applicant()
    {
        return $this->belongsTo(Applicant::class);
    }

    public function scopeNationalId($query)
    {
        return $query->where('type', self::TYPE_NATIONAL_ID);
    }

    public function scopeCv($query)
    {
        return $query->where('type', self::TYPE_CV);
    }

    public function scopePhotoCasual($query)
    {
        return $query->where('type', self::TYPE_PHOTO_CASUAL);
    }

    public function scopePhotoOfficial($query)
    {
        return $query->where('type', self::TYPE_PHOTO_OFFICIAL);
    }
}
