<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantNationality extends Model
{
    use SoftDeletes;
    protected $fillable = ['applicant_id', 'country_id'];

    public function applicant()
    {
        return $this->belongsTo(Applicant::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }
}
