<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ApplicantSubmission extends Model
{
  protected $fillable = [
    'applicant_id',
    'ip_address',
    'browser_fingerprint',
    'user_agent',
    'device_type',
    'os',
    'browser',
  ];

  public function applicant(): BelongsTo
  {
    return $this->belongsTo(Applicant::class);
  }
}
