<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Evaluation extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'evaluation_sheet_id',
        'judge_id',
        'evaluated_user_id',
        'answers',
        'score',
        'submitted_at',
    ];

    protected $casts = [
        'answers' => 'json',
        'submitted_at' => 'datetime',
    ];

    public function evaluationSheet(): BelongsTo
    {
        return $this->belongsTo(EvaluationSheet::class);
    }

    public function judge(): BelongsTo
    {
        return $this->belongsTo(User::class, 'judge_id');
    }

    public function evaluatedUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'evaluated_user_id');
    }
}
