<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class EvaluationAggregate extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'evaluated_user_id',
        'total_evaluations',
        'criterion_averages',
        'overall_score',
        'completed_at',
    ];

    protected $casts = [
        'criterion_averages' => 'json',
        'completed_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'evaluated_user_id');
    }
}
