<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Exam extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'title',
        'description',
        'form_schema',
        'is_published',
        'published_at',
        'deadline_at',
        'max_attempts',
    ];

    protected $casts = [
        'form_schema' => 'json',
        'is_published' => 'boolean',
        'published_at' => 'datetime',
        'deadline_at' => 'datetime',
    ];

    public function attempts(): HasMany
    {
        return $this->hasMany(ExamAttempt::class);
    }
}
