<?php

namespace App\Observers;

use App\Models\User;
use App\Services\AuditService;

class UserObserver
{
    public function __construct(
        protected AuditService $auditService,
    ) {}

    public function created(User $user): void
    {
        $this->auditService->log(
            causer: $user,
            action: 'user.created',
            subject: $user,
        );
    }
}
