<?php

namespace App\Services;

use App\Models\SystemLog;
use Illuminate\Database\Eloquent\Model;

class AuditService
{
    public function log(
        ?Model $causer,
        string $action,
        ?Model $subject = null,
        array $meta = []
    ): SystemLog {
        return SystemLog::create([
            'causer_type' => $causer ? $causer::class : null,
            'causer_id' => $causer?->id,
            'action' => $action,
            'subject_type' => $subject ? $subject::class : null,
            'subject_id' => $subject?->id,
            'meta' => $meta,
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
        ]);
    }
}
