<?php

namespace App\Services;

class FormService
{
    public function getFormSchema(string $formId): array
    {
        return match($formId) {
            'form_a' => $this->getFormA(),
            'form_b' => $this->getFormB(),
            default => throw new \Exception("Form {$formId} not found"),
        };
    }

    private function getFormA(): array
    {
        return [
            'id' => 'form_a',
            'title' => 'Top confidential form for the ministry Registration — Spec A',
            'description' => 'Registration form for Spec A candidates',
            'version' => '1.0',
            'allowed_attempts' => 1,
            'fields' => [
                [
                    'name' => 'national_id',
                    'type' => 'text',
                    'label' => 'National ID',
                    'ui' => ['placeholder' => 'Enter 14-digit national id', 'readonly' => true],
                    'validation' => ['required' => true, 'pattern' => '^[0-9]{14}$'],
                    'prefill_from_id' => true,
                ],
                [
                    'name' => 'full_name',
                    'type' => 'text',
                    'label' => 'Full Name',
                    'ui' => ['placeholder' => 'As in national ID'],
                    'validation' => ['required' => true, 'min' => 3, 'max' => 255],
                ],
                [
                    'name' => 'birthdate',
                    'type' => 'date',
                    'label' => 'Birth Date',
                    'ui' => ['readonly' => true],
                    'validation' => ['required' => true],
                ],
                [
                    'name' => 'email',
                    'type' => 'email',
                    'label' => 'Email Address',
                    'validation' => ['required' => true, 'email' => true],
                ],
                [
                    'name' => 'phone',
                    'type' => 'text',
                    'label' => 'Mobile Number',
                    'validation' => ['required' => true, 'pattern' => '^[0-9+]{7,15}$'],
                ],
                [
                    'name' => 'essay_question_1',
                    'type' => 'textarea',
                    'label' => 'Personal Statement',
                    'ui' => ['placeholder' => 'Write your personal statement (min 50 words)', 'rows' => 8],
                    'validation' => ['required' => true, 'min_words' => 50],
                ],
                [
                    'name' => 'mcq_1',
                    'type' => 'mcq',
                    'label' => 'Which subject do you prefer?',
                    'options' => [
                        ['value' => 'math', 'label' => 'Mathematics'],
                        ['value' => 'physics', 'label' => 'Physics'],
                        ['value' => 'chem', 'label' => 'Chemistry'],
                    ],
                    'validation' => ['required' => true, 'max_select' => 1],
                ],
                [
                    'name' => 'tf_1',
                    'type' => 'true_false',
                    'label' => 'Do you meet all eligibility requirements?',
                    'validation' => ['required' => true],
                ],
                [
                    'name' => 'supporting_documents',
                    'type' => 'file',
                    'label' => 'Upload supporting documents (PDF, JPG)',
                    'ui' => ['multiple' => true, 'max_files' => 5],
                    'validation' => ['required' => false, 'max_size_mb' => 10, 'allowed_types' => ['application/pdf', 'image/jpeg', 'image/png']],
                ],
                [
                    'name' => 'accept_terms',
                    'type' => 'checkbox',
                    'label' => 'I accept terms & conditions',
                    'validation' => ['required' => true],
                ],
            ],
            'ui_options' => [
                'autosave_seconds' => 10,
                'save_endpoint' => '/api/v1/registrations/autosave',
                'submit_endpoint' => '/api/v1/registrations',
            ],
        ];
    }

    private function getFormB(): array
    {
        return [
            'id' => 'form_b',
            'title' => 'Top confidential form for the ministry Registration — Spec B',
            'description' => 'Registration form for Spec B candidates',
            'version' => '1.0',
            'allowed_attempts' => 1,
            'fields' => [
                [
                    'name' => 'national_id',
                    'type' => 'text',
                    'label' => 'National ID',
                    'ui' => ['placeholder' => 'Enter 14-digit national id', 'readonly' => true],
                    'validation' => ['required' => true, 'pattern' => '^[0-9]{14}$'],
                    'prefill_from_id' => true,
                ],
                [
                    'name' => 'full_name',
                    'type' => 'text',
                    'label' => 'Full Name',
                    'ui' => ['placeholder' => 'As in national ID'],
                    'validation' => ['required' => true, 'min' => 3, 'max' => 255],
                ],
                [
                    'name' => 'birthdate',
                    'type' => 'date',
                    'label' => 'Birth Date',
                    'ui' => ['readonly' => true],
                    'validation' => ['required' => true],
                ],
                [
                    'name' => 'email',
                    'type' => 'email',
                    'label' => 'Email Address',
                    'validation' => ['required' => true, 'email' => true],
                ],
                [
                    'name' => 'phone',
                    'type' => 'text',
                    'label' => 'Mobile Number',
                    'validation' => ['required' => true, 'pattern' => '^[0-9+]{7,15}$'],
                ],
                [
                    'name' => 'experience',
                    'type' => 'textarea',
                    'label' => 'Professional Experience',
                    'ui' => ['placeholder' => 'Describe your relevant experience', 'rows' => 8],
                    'validation' => ['required' => true, 'min_words' => 50],
                ],
                [
                    'name' => 'cv',
                    'type' => 'file',
                    'label' => 'Upload CV (PDF)',
                    'ui' => ['multiple' => false],
                    'validation' => ['required' => true, 'max_size_mb' => 5, 'allowed_types' => ['application/pdf']],
                ],
                [
                    'name' => 'accept_terms',
                    'type' => 'checkbox',
                    'label' => 'I accept terms & conditions',
                    'validation' => ['required' => true],
                ],
            ],
            'ui_options' => [
                'autosave_seconds' => 10,
                'save_endpoint' => '/api/v1/registrations/autosave',
                'submit_endpoint' => '/api/v1/registrations',
            ],
        ];
    }
}
