<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('evaluation_sheets', function (Blueprint $table) {
            // Rename judge_id to created_by
            $table->renameColumn('judge_id', 'created_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('evaluation_sheets', function (Blueprint $table) {
            // Rename created_by back to judge_id
            $table->renameColumn('created_by', 'judge_id');
        });
    }
};
