<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CountriesSeeder extends Seeder
{
    public function run(): void
    {
        $countries = [
            ["name_en" => "Afghanistan", "name_ar" => "أفغانستان", "iso_code" => "AF"],
            ["name_en" => "Albania", "name_ar" => "ألبانيا", "iso_code" => "AL"],
            ["name_en" => "Algeria", "name_ar" => "الجزائر", "iso_code" => "DZ"],
            ["name_en" => "Andorra", "name_ar" => "أندورا", "iso_code" => "AD"],
            ["name_en" => "Angola", "name_ar" => "أنغولا", "iso_code" => "AO"],
            ["name_en" => "Antigua and Barbuda", "name_ar" => "أنتيغوا وباربودا", "iso_code" => "AG"],
            ["name_en" => "Argentina", "name_ar" => "الأرجنتين", "iso_code" => "AR"],
            ["name_en" => "Armenia", "name_ar" => "أرمينيا", "iso_code" => "AM"],
            ["name_en" => "Australia", "name_ar" => "أستراليا", "iso_code" => "AU"],
            ["name_en" => "Austria", "name_ar" => "النمسا", "iso_code" => "AT"],
            ["name_en" => "Azerbaijan", "name_ar" => "أذربيجان", "iso_code" => "AZ"],
            ["name_en" => "Bahamas", "name_ar" => "جزر البهاما", "iso_code" => "BS"],
            ["name_en" => "Bahrain", "name_ar" => "البحرين", "iso_code" => "BH"],
            ["name_en" => "Bangladesh", "name_ar" => "بنغلاديش", "iso_code" => "BD"],
            ["name_en" => "Barbados", "name_ar" => "باربادوس", "iso_code" => "BB"],
            ["name_en" => "Belarus", "name_ar" => "بيلاروسيا", "iso_code" => "BY"],
            ["name_en" => "Belgium", "name_ar" => "بلجيكا", "iso_code" => "BE"],
            ["name_en" => "Belize", "name_ar" => "بليز", "iso_code" => "BZ"],
            ["name_en" => "Benin", "name_ar" => "بنين", "iso_code" => "BJ"],
            ["name_en" => "Bhutan", "name_ar" => "بوتان", "iso_code" => "BT"],
            ["name_en" => "Bolivia", "name_ar" => "بوليفيا", "iso_code" => "BO"],
            ["name_en" => "Bosnia and Herzegovina", "name_ar" => "البوسنة والهرسك", "iso_code" => "BA"],
            ["name_en" => "Botswana", "name_ar" => "بوتسوانا", "iso_code" => "BW"],
            ["name_en" => "Brazil", "name_ar" => "البرازيل", "iso_code" => "BR"],
            ["name_en" => "Brunei", "name_ar" => "بروناي", "iso_code" => "BN"],
            ["name_en" => "Bulgaria", "name_ar" => "بلغاريا", "iso_code" => "BG"],
            ["name_en" => "Burkina Faso", "name_ar" => "بوركينا فاسو", "iso_code" => "BF"],
            ["name_en" => "Burundi", "name_ar" => "بوروندي", "iso_code" => "BI"],
            ["name_en" => "Cabo Verde", "name_ar" => "الرأس الأخضر", "iso_code" => "CV"],
            ["name_en" => "Cambodia", "name_ar" => "كمبوديا", "iso_code" => "KH"],
            ["name_en" => "Cameroon", "name_ar" => "الكاميرون", "iso_code" => "CM"],
            ["name_en" => "Canada", "name_ar" => "كندا", "iso_code" => "CA"],
            ["name_en" => "Central African Republic", "name_ar" => "جمهورية أفريقيا الوسطى", "iso_code" => "CF"],
            ["name_en" => "Chad", "name_ar" => "تشاد", "iso_code" => "TD"],
            ["name_en" => "Chile", "name_ar" => "تشيلي", "iso_code" => "CL"],
            ["name_en" => "China", "name_ar" => "الصين", "iso_code" => "CN"],
            ["name_en" => "Colombia", "name_ar" => "كولومبيا", "iso_code" => "CO"],
            ["name_en" => "Comoros", "name_ar" => "جزر القمر", "iso_code" => "KM"],
            ["name_en" => "Congo (Republic)", "name_ar" => "الكونغو", "iso_code" => "CG"],
            ["name_en" => "Congo (DRC)", "name_ar" => "جمهورية الكونغو الديمقراطية", "iso_code" => "CD"],
            ["name_en" => "Costa Rica", "name_ar" => "كوستاريكا", "iso_code" => "CR"],
            ["name_en" => "Croatia", "name_ar" => "كرواتيا", "iso_code" => "HR"],
            ["name_en" => "Cuba", "name_ar" => "كوبا", "iso_code" => "CU"],
            ["name_en" => "Cyprus", "name_ar" => "قبرص", "iso_code" => "CY"],
            ["name_en" => "Czech Republic", "name_ar" => "التشيك", "iso_code" => "CZ"],
            ["name_en" => "Denmark", "name_ar" => "الدنمارك", "iso_code" => "DK"],
            ["name_en" => "Djibouti", "name_ar" => "جيبوتي", "iso_code" => "DJ"],
            ["name_en" => "Dominica", "name_ar" => "دومينيكا", "iso_code" => "DM"],
            ["name_en" => "Dominican Republic", "name_ar" => "جمهورية الدومينيكان", "iso_code" => "DO"],
            ["name_en" => "Ecuador", "name_ar" => "الإكوادور", "iso_code" => "EC"],
            ["name_en" => "Egypt", "name_ar" => "مصر", "iso_code" => "EG"],
            ["name_en" => "El Salvador", "name_ar" => "السلفادور", "iso_code" => "SV"],
            ["name_en" => "Equatorial Guinea", "name_ar" => "غينيا الاستوائية", "iso_code" => "GQ"],
            ["name_en" => "Eritrea", "name_ar" => "إريتريا", "iso_code" => "ER"],
            ["name_en" => "Estonia", "name_ar" => "إستونيا", "iso_code" => "EE"],
            ["name_en" => "Eswatini", "name_ar" => "إسواتيني", "iso_code" => "SZ"],
            ["name_en" => "Ethiopia", "name_ar" => "إثيوبيا", "iso_code" => "ET"],
            ["name_en" => "Fiji", "name_ar" => "فيجي", "iso_code" => "FJ"],
            ["name_en" => "Finland", "name_ar" => "فنلندا", "iso_code" => "FI"],
            ["name_en" => "France", "name_ar" => "فرنسا", "iso_code" => "FR"],
            ["name_en" => "Gabon", "name_ar" => "الغابون", "iso_code" => "GA"],
            ["name_en" => "Gambia", "name_ar" => "غامبيا", "iso_code" => "GM"],
            ["name_en" => "Georgia", "name_ar" => "جورجيا", "iso_code" => "GE"],
            ["name_en" => "Germany", "name_ar" => "ألمانيا", "iso_code" => "DE"],
            ["name_en" => "Ghana", "name_ar" => "غانا", "iso_code" => "GH"],
            ["name_en" => "Greece", "name_ar" => "اليونان", "iso_code" => "GR"],
            ["name_en" => "Grenada", "name_ar" => "غرينادا", "iso_code" => "GD"],
            ["name_en" => "Guatemala", "name_ar" => "غواتيمالا", "iso_code" => "GT"],
            ["name_en" => "Guinea", "name_ar" => "غينيا", "iso_code" => "GN"],
            ["name_en" => "Guinea-Bissau", "name_ar" => "غينيا بيساو", "iso_code" => "GW"],
            ["name_en" => "Guyana", "name_ar" => "غيانا", "iso_code" => "GY"],
            ["name_en" => "Haiti", "name_ar" => "هايتي", "iso_code" => "HT"],
            ["name_en" => "Honduras", "name_ar" => "هندوراس", "iso_code" => "HN"],
            ["name_en" => "Hungary", "name_ar" => "المجر", "iso_code" => "HU"],
            ["name_en" => "Iceland", "name_ar" => "آيسلندا", "iso_code" => "IS"],
            ["name_en" => "India", "name_ar" => "الهند", "iso_code" => "IN"],
            ["name_en" => "Indonesia", "name_ar" => "إندونيسيا", "iso_code" => "ID"],
            ["name_en" => "Iran", "name_ar" => "إيران", "iso_code" => "IR"],
            ["name_en" => "Iraq", "name_ar" => "العراق", "iso_code" => "IQ"],
            ["name_en" => "Ireland", "name_ar" => "أيرلندا", "iso_code" => "IE"],
            ["name_en" => "Italy", "name_ar" => "إيطاليا", "iso_code" => "IT"],
            ["name_en" => "Jamaica", "name_ar" => "جامايكا", "iso_code" => "JM"],
            ["name_en" => "Japan", "name_ar" => "اليابان", "iso_code" => "JP"],
            ["name_en" => "Jordan", "name_ar" => "الأردن", "iso_code" => "JO"],
            ["name_en" => "Kazakhstan", "name_ar" => "كازاخستان", "iso_code" => "KZ"],
            ["name_en" => "Kenya", "name_ar" => "كينيا", "iso_code" => "KE"],
            ["name_en" => "Kiribati", "name_ar" => "كيريباتي", "iso_code" => "KI"],
            ["name_en" => "Kuwait", "name_ar" => "الكويت", "iso_code" => "KW"],
            ["name_en" => "Kyrgyzstan", "name_ar" => "قرغيزستان", "iso_code" => "KG"],
            ["name_en" => "Laos", "name_ar" => "لاوس", "iso_code" => "LA"],
            ["name_en" => "Latvia", "name_ar" => "لاتفيا", "iso_code" => "LV"],
            ["name_en" => "Lebanon", "name_ar" => "لبنان", "iso_code" => "LB"],
            ["name_en" => "Lesotho", "name_ar" => "ليسوتو", "iso_code" => "LS"],
            ["name_en" => "Liberia", "name_ar" => "ليبيريا", "iso_code" => "LR"],
            ["name_en" => "Libya", "name_ar" => "ليبيا", "iso_code" => "LY"],
            ["name_en" => "Liechtenstein", "name_ar" => "ليختنشتاين", "iso_code" => "LI"],
            ["name_en" => "Lithuania", "name_ar" => "ليتوانيا", "iso_code" => "LT"],
            ["name_en" => "Luxembourg", "name_ar" => "لوكسمبورغ", "iso_code" => "LU"],
            ["name_en" => "Madagascar", "name_ar" => "مدغشقر", "iso_code" => "MG"],
            ["name_en" => "Malawi", "name_ar" => "مالاوي", "iso_code" => "MW"],
            ["name_en" => "Malaysia", "name_ar" => "ماليزيا", "iso_code" => "MY"],
            ["name_en" => "Maldives", "name_ar" => "المالديف", "iso_code" => "MV"],
            ["name_en" => "Mali", "name_ar" => "مالي", "iso_code" => "ML"],
            ["name_en" => "Malta", "name_ar" => "مالطا", "iso_code" => "MT"],
            ["name_en" => "Marshall Islands", "name_ar" => "جزر مارشال", "iso_code" => "MH"],
            ["name_en" => "Mauritania", "name_ar" => "موريتانيا", "iso_code" => "MR"],
            ["name_en" => "Mauritius", "name_ar" => "موريشيوس", "iso_code" => "MU"],
            ["name_en" => "Mexico", "name_ar" => "المكسيك", "iso_code" => "MX"],
            ["name_en" => "Micronesia", "name_ar" => "ميكرونيزيا", "iso_code" => "FM"],
            ["name_en" => "Moldova", "name_ar" => "مولدوفا", "iso_code" => "MD"],
            ["name_en" => "Monaco", "name_ar" => "موناكو", "iso_code" => "MC"],
            ["name_en" => "Mongolia", "name_ar" => "منغوليا", "iso_code" => "MN"],
            ["name_en" => "Montenegro", "name_ar" => "الجبل الأسود", "iso_code" => "ME"],
            ["name_en" => "Morocco", "name_ar" => "المغرب", "iso_code" => "MA"],
            ["name_en" => "Mozambique", "name_ar" => "موزمبيق", "iso_code" => "MZ"],
            ["name_en" => "Myanmar", "name_ar" => "ميانمار", "iso_code" => "MM"],
            ["name_en" => "Namibia", "name_ar" => "ناميبيا", "iso_code" => "NA"],
            ["name_en" => "Nauru", "name_ar" => "ناورو", "iso_code" => "NR"],
            ["name_en" => "Nepal", "name_ar" => "نيبال", "iso_code" => "NP"],
            ["name_en" => "Netherlands", "name_ar" => "هولندا", "iso_code" => "NL"],
            ["name_en" => "New Zealand", "name_ar" => "نيوزيلندا", "iso_code" => "NZ"],
            ["name_en" => "Nicaragua", "name_ar" => "نيكاراغوا", "iso_code" => "NI"],
            ["name_en" => "Niger", "name_ar" => "النيجر", "iso_code" => "NE"],
            ["name_en" => "Nigeria", "name_ar" => "نيجيريا", "iso_code" => "NG"],
            ["name_en" => "North Korea", "name_ar" => "كوريا الشمالية", "iso_code" => "KP"],
            ["name_en" => "North Macedonia", "name_ar" => "مقدونيا الشمالية", "iso_code" => "MK"],
            ["name_en" => "Norway", "name_ar" => "النرويج", "iso_code" => "NO"],
            ["name_en" => "Oman", "name_ar" => "عمان", "iso_code" => "OM"],
            ["name_en" => "Pakistan", "name_ar" => "باكستان", "iso_code" => "PK"],
            ["name_en" => "Palau", "name_ar" => "بالاو", "iso_code" => "PW"],
            ["name_en" => "Panama", "name_ar" => "بنما", "iso_code" => "PA"],
            ["name_en" => "Papua New Guinea", "name_ar" => "بابوا غينيا الجديدة", "iso_code" => "PG"],
            ["name_en" => "Paraguay", "name_ar" => "باراغواي", "iso_code" => "PY"],
            ["name_en" => "Peru", "name_ar" => "بيرو", "iso_code" => "PE"],
            ["name_en" => "Philippines", "name_ar" => "الفلبين", "iso_code" => "PH"],
            ["name_en" => "Poland", "name_ar" => "بولندا", "iso_code" => "PL"],
            ["name_en" => "Portugal", "name_ar" => "البرتغال", "iso_code" => "PT"],
            ["name_en" => "Qatar", "name_ar" => "قطر", "iso_code" => "QA"],
            ["name_en" => "Romania", "name_ar" => "رومانيا", "iso_code" => "RO"],
            ["name_en" => "Russia", "name_ar" => "روسيا", "iso_code" => "RU"],
            ["name_en" => "Rwanda", "name_ar" => "رواندا", "iso_code" => "RW"],
            ["name_en" => "Saint Kitts and Nevis", "name_ar" => "سانت كيتس ونيفيس", "iso_code" => "KN"],
            ["name_en" => "Saint Lucia", "name_ar" => "سانت لوسيا", "iso_code" => "LC"],
            ["name_en" => "Saint Vincent and the Grenadines", "name_ar" => "سانت فنسنت وجزر غرينادين", "iso_code" => "VC"],
            ["name_en" => "Samoa", "name_ar" => "ساموا", "iso_code" => "WS"],
            ["name_en" => "San Marino", "name_ar" => "سان مارينو", "iso_code" => "SM"],
            ["name_en" => "Sao Tome and Principe", "name_ar" => "ساو تومي وبرينسيبي", "iso_code" => "ST"],
            ["name_en" => "Saudi Arabia", "name_ar" => "السعودية", "iso_code" => "SA"],
            ["name_en" => "Senegal", "name_ar" => "السنغال", "iso_code" => "SN"],
            ["name_en" => "Serbia", "name_ar" => "صربيا", "iso_code" => "RS"],
            ["name_en" => "Seychelles", "name_ar" => "سيشل", "iso_code" => "SC"],
            ["name_en" => "Sierra Leone", "name_ar" => "سيراليون", "iso_code" => "SL"],
            ["name_en" => "Singapore", "name_ar" => "سنغافورة", "iso_code" => "SG"],
            ["name_en" => "Slovakia", "name_ar" => "سلوفاكيا", "iso_code" => "SK"],
            ["name_en" => "Slovenia", "name_ar" => "سلوفينيا", "iso_code" => "SI"],
            ["name_en" => "Solomon Islands", "name_ar" => "جزر سليمان", "iso_code" => "SB"],
            ["name_en" => "Somalia", "name_ar" => "الصومال", "iso_code" => "SO"],
            ["name_en" => "South Africa", "name_ar" => "جنوب أفريقيا", "iso_code" => "ZA"],
            ["name_en" => "South Korea", "name_ar" => "كوريا الجنوبية", "iso_code" => "KR"],
            ["name_en" => "South Sudan", "name_ar" => "جنوب السودان", "iso_code" => "SS"],
            ["name_en" => "Spain", "name_ar" => "إسبانيا", "iso_code" => "ES"],
            ["name_en" => "Sri Lanka", "name_ar" => "سريلانكا", "iso_code" => "LK"],
            ["name_en" => "Sudan", "name_ar" => "السودان", "iso_code" => "SD"],
            ["name_en" => "Suriname", "name_ar" => "سورينام", "iso_code" => "SR"],
            ["name_en" => "Sweden", "name_ar" => "السويد", "iso_code" => "SE"],
            ["name_en" => "Switzerland", "name_ar" => "سويسرا", "iso_code" => "CH"],
            ["name_en" => "Syria", "name_ar" => "سوريا", "iso_code" => "SY"],
            ["name_en" => "Taiwan", "name_ar" => "تايوان", "iso_code" => "TW"],
            ["name_en" => "Tajikistan", "name_ar" => "طاجيكستان", "iso_code" => "TJ"],
            ["name_en" => "Tanzania", "name_ar" => "تنزانيا", "iso_code" => "TZ"],
            ["name_en" => "Thailand", "name_ar" => "تايلاند", "iso_code" => "TH"],
            ["name_en" => "Timor-Leste", "name_ar" => "تيمور الشرقية", "iso_code" => "TL"],
            ["name_en" => "Togo", "name_ar" => "توغو", "iso_code" => "TG"],
            ["name_en" => "Tonga", "name_ar" => "تونغا", "iso_code" => "TO"],
            ["name_en" => "Trinidad and Tobago", "name_ar" => "ترينيداد وتوباغو", "iso_code" => "TT"],
            ["name_en" => "Tunisia", "name_ar" => "تونس", "iso_code" => "TN"],
            ["name_en" => "Turkey", "name_ar" => "تركيا", "iso_code" => "TR"],
            ["name_en" => "Turkmenistan", "name_ar" => "تركمانستان", "iso_code" => "TM"],
            ["name_en" => "Tuvalu", "name_ar" => "توفالو", "iso_code" => "TV"],
            ["name_en" => "Uganda", "name_ar" => "أوغندا", "iso_code" => "UG"],
            ["name_en" => "Ukraine", "name_ar" => "أوكرانيا", "iso_code" => "UA"],
            ["name_en" => "United Arab Emirates", "name_ar" => "الإمارات", "iso_code" => "AE"],
            ["name_en" => "United Kingdom", "name_ar" => "المملكة المتحدة", "iso_code" => "GB"],
            ["name_en" => "United States", "name_ar" => "الولايات المتحدة", "iso_code" => "US"],
            ["name_en" => "Uruguay", "name_ar" => "الأوروغواي", "iso_code" => "UY"],
            ["name_en" => "Uzbekistan", "name_ar" => "أوزبكستان", "iso_code" => "UZ"],
            ["name_en" => "Vanuatu", "name_ar" => "فانواتو", "iso_code" => "VU"],
            ["name_en" => "Vatican City", "name_ar" => "الفاتيكان", "iso_code" => "VA"],
            ["name_en" => "Venezuela", "name_ar" => "فنزويلا", "iso_code" => "VE"],
            ["name_en" => "Vietnam", "name_ar" => "فيتنام", "iso_code" => "VN"],
            ["name_en" => "Yemen", "name_ar" => "اليمن", "iso_code" => "YE"],
            ["name_en" => "Zambia", "name_ar" => "زامبيا", "iso_code" => "ZM"],
            ["name_en" => "Zimbabwe", "name_ar" => "زيمبابوي", "iso_code" => "ZW"],
        ];

        DB::table('countries')->insert($countries);
    }
}
