<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LanguagesSeeder extends Seeder
{
    public function run(): void
    {
        $languages = [
            ['name_en' => 'Arabic', 'name_ar' => 'العربية', 'iso_code' => 'AR'],
            ['name_en' => 'English', 'name_ar' => 'الإنجليزية', 'iso_code' => 'EN'],
            ['name_en' => 'French', 'name_ar' => 'الفرنسية', 'iso_code' => 'FR'],
            ['name_en' => 'German', 'name_ar' => 'الألمانية', 'iso_code' => 'DE'],
            ['name_en' => 'Spanish', 'name_ar' => 'الإسبانية', 'iso_code' => 'ES'],
            ['name_en' => 'Italian', 'name_ar' => 'الإيطالية', 'iso_code' => 'IT'],
            ['name_en' => 'Chinese', 'name_ar' => 'الصينية', 'iso_code' => 'ZH'],
            ['name_en' => 'Japanese', 'name_ar' => 'اليابانية', 'iso_code' => 'JA'],
            ['name_en' => 'Russian', 'name_ar' => 'الروسية', 'iso_code' => 'RU'],
            ['name_en' => 'Portuguese', 'name_ar' => 'البرتغالية', 'iso_code' => 'PT'],
            ['name_en' => 'Hindi', 'name_ar' => 'الهندية', 'iso_code' => 'HI'],
            ['name_en' => 'Bengali', 'name_ar' => 'البنغالية', 'iso_code' => 'BN'],
            ['name_en' => 'Turkish', 'name_ar' => 'التركية', 'iso_code' => 'TR'],
            ['name_en' => 'Korean', 'name_ar' => 'الكورية', 'iso_code' => 'KO'],
            ['name_en' => 'Dutch', 'name_ar' => 'الهولندية', 'iso_code' => 'NL'],
            ['name_en' => 'Swedish', 'name_ar' => 'السويدية', 'iso_code' => 'SV'],
            ['name_en' => 'Greek', 'name_ar' => 'اليونانية', 'iso_code' => 'EL'],
            ['name_en' => 'Hebrew', 'name_ar' => 'العبرية', 'iso_code' => 'HE'],
            ['name_en' => 'Swahili', 'name_ar' => 'السواحيلية', 'iso_code' => 'SW'],
        ];

        DB::table('languages')->insert($languages);
    }
}
