<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // General Settings
            [
                'key' => 'registration_open',
                'value' => 'true',
                'type' => 'boolean',
                'description' => 'Allow new registrations',
            ],
            [
                'key' => 'maintenance_mode',
                'value' => 'false',
                'type' => 'boolean',
                'description' => 'Enable maintenance mode',
            ],

            // Exam Settings
            [
                'key' => 'exam_duration',
                'value' => '60',
                'type' => 'integer',
                'description' => 'Default exam duration in minutes',
            ],
            [
                'key' => 'passing_score',
                'value' => '70',
                'type' => 'integer',
                'description' => 'Minimum passing score percentage',
            ],
            [
                'key' => 'auto_publish_results',
                'value' => 'false',
                'type' => 'boolean',
                'description' => 'Automatically publish exam results',
            ],

            // Security Settings
            [
                'key' => 'max_login_attempts',
                'value' => '5',
                'type' => 'integer',
                'description' => 'Maximum login attempts before lockout',
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }

        $this->command->info('Settings seeded successfully!');
    }
}
