import { NextRequest, NextResponse } from "next/server";

export async function POST(request: NextRequest) {
  try {
    // مهم: لا تستخدم request.json()
    const formData = await request.formData();

    // تحويل FormData إلى FormData جديد لإعادة الإرسال
    const fd = new FormData();

    // نسخ الحقول العادية والملفات
    formData.forEach((value, key) => {
      // إذا كان ملف، ضعه مباشرة
      if (value instanceof File) {
        fd.append(key, value);
      } else {
        fd.append(key, value.toString());
      }
    });

    const API_ENDPOINT =
      process.env.NEXT_PUBLIC_API_URL ||
      "http://localhost:8000/api/v1/applicants/";

    const response = await fetch(API_ENDPOINT, {
      method: "POST",
      body: fd, // بدون headers
    });

    if (!response.ok) {
      const errorData = await response.json().catch(() => null);
      return NextResponse.json(
        {
          success: false,
          message: "API submission failed",
          error: errorData,
        },
        { status: response.status }
      );
    }

    const data = await response.json();
    return NextResponse.json({ success: true, data }, { status: 200 });
  } catch (error: any) {
    console.error("Submission error:", error);
    return NextResponse.json(
      { success: false, message: error.message },
      { status: 500 }
    );
  }
}
