"use client";

export default function MaintenancePage() {
  return (
    <main className="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 flex items-center justify-center px-4">
      <div
        className="max-w-2xl mx-auto text-center bg-white rounded-lg shadow-xl p-12"
        dir="rtl"
      >
        <div className="mb-8">
          <svg
            className="w-24 h-24 mx-auto text-yellow-500"
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              strokeWidth={2}
              d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"
            />
          </svg>
        </div>

        <h1 className="text-4xl font-bold text-gray-900 mb-4">
          النظام في وضع الصيانة
        </h1>

        <p className="text-xl text-gray-700 mb-8">
          نعتذر عن الإزعاج، النظام قيد الصيانة حالياً
        </p>

        <div className="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-8">
          <p className="text-gray-600 mb-4">
            نحن نعمل على تحسين النظام لتقديم خدمة أفضل لكم. نتوقع أن يعود النظام
            للعمل قريباً.
          </p>
          <p className="text-gray-600">يرجى المحاولة مرة أخرى في وقت لاحق.</p>
        </div>

        {/* <button
          onClick={() => window.location.reload()}
          className="bg-blue-600 text-white px-8 py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium"
        >
          إعادة المحاولة
        </button> */}

        {/* <div className="mt-8 text-sm text-gray-500">
          <p>للاستفسارات، يرجى التواصل معنا على:</p>
          <p className="mt-2">
            <a
              href="mailto:admin@youth-diplomacy.com"
              className="text-blue-600 hover:underline"
            >
              admin@youth-diplomacy.com
            </a>
          </p>
        </div> */}
      </div>
    </main>
  );
}
