"use client";

export default function UnauthorizedPage() {
  return (
    <div
      className="min-h-screen flex items-center justify-center bg-gradient-to-br from-red-50 to-orange-50"
      dir="rtl"
    >
      <div className="bg-white rounded-xl shadow-xl p-8 max-w-md w-full text-center">
        <div className="w-20 h-20 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
          <svg
            className="w-10 h-10 text-red-600"
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              strokeWidth={2}
              d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"
            />
          </svg>
        </div>
        <h1 className="text-2xl font-bold text-gray-900 mb-4">غير مصرح لك</h1>
        <p className="text-gray-600 mb-6">
          ليس لديك صلاحية للوصول إلى هذه الصفحة
        </p>
        <a
          href="/login"
          className="inline-block px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-medium transition-colors"
        >
          العودة لتسجيل الدخول
        </a>
      </div>
    </div>
  );
}
