"use client";

import React from "react";
import { FormField as FormFieldType } from "@/lib/types";
import { FileUpload } from "./FileUpload";

interface DocumentsUploadProps {
  field: FormFieldType;
  register: any;
  errors: any;
  setValue: any;
}

export function DocumentsUpload({
  field,
  register,
  errors,
  setValue,
}: DocumentsUploadProps) {
  return (
    <div className="border rounded-lg p-6 bg-gray-50">
      <h3 className="text-lg font-semibold text-gray-800 mb-4">
        {field.label}
      </h3>

      <div className="space-y-6">
        {field.objectFields?.map((docField) => {
          const fieldName = `${field.name}.${docField.name}`;
          const fieldError = errors[field.name]?.[docField.name];

          return (
            <FileUpload
              key={fieldName}
              label={docField.label}
              name={fieldName}
              required={docField.required}
              multiple={docField.multiple}
              accept={docField.accept}
              register={register}
              setValue={setValue}
              error={fieldError?.message}
            />
          );
        })}
      </div>

      {errors[field.name]?.message && (
        <p className="mt-2 text-sm text-red-500">
          {errors[field.name]?.message}
        </p>
      )}
    </div>
  );
}
