export interface User {
  id: number;
  name: string;
  email: string;
  role: "user" | "judge" | "admin";
  status:
    | "pending"
    | "exam_completed"
    | "under_evaluation"
    | "evaluated"
    | "accepted"
    | "rejected";
  created_at: string;
}

export const getAuthToken = (): string | null => {
  if (typeof window === "undefined") return null;
  return localStorage.getItem("auth_token");
};

export const setAuthToken = (token: string): void => {
  if (typeof window !== "undefined") {
    localStorage.setItem("auth_token", token);
  }
};

export const removeAuthToken = (): void => {
  if (typeof window !== "undefined") {
    localStorage.removeItem("auth_token");
    localStorage.removeItem("user_data");
  }
};

export const getUser = (): User | null => {
  if (typeof window === "undefined") return null;
  const userData = localStorage.getItem("user_data");
  return userData ? JSON.parse(userData) : null;
};

export const setUser = (user: User): void => {
  if (typeof window !== "undefined") {
    localStorage.setItem("user_data", JSON.stringify(user));
  }
};

export const isAuthenticated = (): boolean => {
  return !!getAuthToken();
};

export const hasRole = (role: string | string[]): boolean => {
  const user = getUser();
  if (!user) return false;

  if (Array.isArray(role)) {
    return role.includes(user.role);
  }
  return user.role === role;
};
