export interface ValidationRule {
  required?: boolean;
  type?: string;
  digits?: number;
  unique?: string;
  exists?: string;
  in?: string[];
  mimes?: string[];
  email?: boolean;
  nullable?: boolean;
  required_if?: string;
}

export interface FieldOption {
  value: string | boolean;
  label: string;
}

export interface ArrayField {
  name: string;
  label: string;
  type: string;
  required?: boolean;
  options?: string[] | FieldOption[];
  optionsEndpoint?: string;
  validation?: ValidationRule;
  errorMessage?: string;
  errorMessages?: Partial<Record<string, string>>;
}

export interface FormField {
  name: string;
  label: string;
  type: string;
  required?: boolean;
  pattern?: string;
  placeholder?: string;
  readonly?: boolean;
  accept?: string;
  options?: string[] | FieldOption[];
  optionsEndpoint?: string;
  conditional?: {
    field: string;
    value: string | boolean;
  };
  multiple?: boolean;
  validation?: ValidationRule;
  errorMessage?: string;
  errorMessages?: Partial<Record<string, string>>;
  arrayFields?: ArrayField[];
  objectFields?: FormField[];
}

export interface FormSection {
  title: string;
  description?: string;
  fields: FormField[];
}

export interface FormConfig {
  formTitle: string;
  sections: FormSection[];
}

export interface FormData {
  [key: string]: any;
}
